unit Copyu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Fcopy, Pctcplt, Copymult;

type
  TForm1 = class(TForm)
    FileCopy1: TFileCopy;
    Button1: TButton;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button2: TButton;
    Button3: TButton;
    ComboBox1: TComboBox;
    Label3: TLabel;
    OpenDialog1: TOpenDialog;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure FileCopy1Finished(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FileCopy1Start(Sender: TObject);
    procedure FileCopy1ProgressChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  LoopCount: LongInt;
begin
  FileCopy1.SourceFilenames.Clear;

  if ListBox1.Items.Count = 0 then
  begin
    ShowMessage('No Source Files Assigned.');
    Exit;
  end
  else
  begin
    LoopCount := 0;
    repeat
      FileCopy1.SourceFilenames.Add(ListBox1.Items[LoopCount]);
      Inc(LoopCount);
    until LoopCount > ListBox1.Items.Count - 1;
  end;

  if Edit2.Text = '' then
  begin
    ShowMessage('No Target File Assigned.');
    Exit;
  end
  else
    FileCopy1.TargetFilename := Edit2.Text;

  case ComboBox1.ItemIndex of
    0:
      FileCopy1.CopyType := ctBlock;
    1:
      FileCopy1.CopyType := ctStream;
    2:
      FileCopy1.CopyType := ctLZCopy;
    3:
      FileCopy1.CopyType := ctMove;
  else
    FileCopy1.CopyType := ctBlock;
  end;

  FileCopy1.Execute;
end;

procedure TForm1.FileCopy1Finished(Sender: TObject);
begin
  PctComplete.Hide;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ListBox1.Items.Clear;
  FileCopy1.SourceFilenames.Clear;
  Form2.Show;
{  OpenDialog1.Title := 'Choose Source File...';
  if OpenDialog1.Execute then
    Edit1.Text := OpenDialog1.Filename; }
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  OpenDialog1.Title := 'Choose Target File...';
  if OpenDialog1.Execute then
    Edit2.Text := OpenDialog1.Filename;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  ComboBox1.ItemIndex := 0;
end;

procedure TForm1.FileCopy1Start(Sender: TObject);
begin
  PctComplete.Show;
end;

procedure TForm1.FileCopy1ProgressChange(Sender: TObject);
begin
  PctComplete.PctCompleteGauge.Progress := FileCopy1.Progress;
end;

end.
